% to get the others change "K3" to "K10" and/or "prg1" to "prg2"

clear
clc
% addpath('..\Powell')
% addpath('..\Routines')

load('AR1prg2_Nobs500_K10_Nrep2500C_results.mat')
s0_500=stats1(thhat0,theta0');
s1_500=stats1(thhat1,theta0');
s2_500=stats1(thhat2,theta0');

load('AR1prg2_Nobs2000_K10_Nrep2500C_results.mat')
s0_2000=stats1(thhat0,theta0');
s1_2000=stats1(thhat1,theta0');
s2_2000=stats1(thhat2,theta0');

load('AR1prg2_Nobs8000_K10_Nrep2500C_results.mat')
s0_8000=stats1(thhat0,theta0');
s1_8000=stats1(thhat1,theta0');
s2_8000=stats1(thhat2,theta0');

[k1 k2]=size(s0_500);
formatSpec = ['&  $%8.3f $ '];
lbl={'True ' 'Bias ' 'MAE  '};

fprintf('\n\n LOGIT MLE\n\n')
for i1=1:k1
    fprintf(lbl{i1})
    for i2=1:k2
        fprintf(formatSpec,s0_500(i1,i2))
    end
    fprintf(' & ')
    for i2=1:k2
        fprintf(formatSpec,s0_2000(i1,i2))
    end
    fprintf(' & ')
    for i2=1:k2
        fprintf(formatSpec,s0_8000(i1,i2))
    end
    fprintf(' \\\\ \n')
end

fprintf('\n\n LOGIT FE\n\n')
for i1=1:k1
    fprintf(lbl{i1})
    for i2=1:k2
        fprintf(formatSpec,s2_500(i1,i2))
    end
    fprintf(' & ')
    for i2=1:k2
        fprintf(formatSpec,s2_2000(i1,i2))
    end
    fprintf(' & ')
    for i2=1:k2
        fprintf(formatSpec,s2_8000(i1,i2))
    end
    fprintf(' \\\\ \n')
end


fprintf('\n\n GMM\n\n')
for i1=1:k1
    fprintf(lbl{i1})
    for i2=1:k2
        fprintf(formatSpec,s1_500(i1,i2))
    end
    fprintf(' & ')
    for i2=1:k2
        fprintf(formatSpec,s1_2000(i1,i2))
    end
    fprintf(' & ')
    for i2=1:k2
        fprintf(formatSpec,s1_8000(i1,i2))
    end
    fprintf(' \\\\ \n')
end




